<?php
/*

Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)



This file is part of DFTK.

DFTK is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DFTK is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DFTK; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/**
 * @package		dftk
 * @author		Duck <duck@DuckCorp.org>
 * @author		Rtp <rtp@rtp-net.org>
 * @copyright	Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)
 * @license		http://www.gnu.org/licenses/gpl.html					GNU General Public License
 * @version		0.4.0
 */


/**
 * DFTK Stdout Output Class
 *
 * @package		dftk
 * @subpackage	dftk-output
 * @author		Duck <duck@DuckCorp.org>
 *
 * @access		public
 */
class DftkOutputStdout extends DftkOutput
{
	/**
	 * Constructor
	 *
	 * @access		public
	 * @param		object DftkDaTraceManager	&$tracemgr			Language Manager
	 */
	function DftkOutputStdout(&$tracemgr)
	{
		DftkOutput::DftkOutput($tracemgr);
		
		register_shutdown_function(array(&$this, "_DftkOutputStdout"));
	}

	/**
	 * Destructor
	 *
	 * @access		private
	 */
	function _DftkOutputStdout()
	{
	}

	/**
	 * Flush output
	 *
	 * @access		public
	 * @return		object DftkDaTrace			$r					Trace
	 */
	function &flush_output()
	{
		$r =& $this->_tracemgr->create_trace();

		print($this->_header.$this->_content.$this->_footer);

		$r2 =& DftkOutput::flush_output();
		$r->merge_traces($r2);

		return $r;
	}
}

?>
